#include "MainMenu.h"



MainMenu::MainMenu(sf::RenderWindow* hwnd, Input* input) : Level (hwnd, input)
{
	mouseCursor.setInput(userInput);
	mouseCursor.setSize(sf::Vector2f(48, 48));
	mouseCursor.setCollisionBox(sf::FloatRect(0, 0, 48, 48));

	startTexture.loadFromFile("Assets/Sprites/Levels/Main Menu/startGame.png");	//Load the start game texture for mouse input
	startSprite.setTexture(&startTexture);
	startSprite.setPosition(330, 500);
	startSprite.setSize(sf::Vector2f(297, 26));
	startSprite.setCollisionBox(sf::FloatRect(0, 0, 297, 26));	//Set the collision box for mouse input

	helpTexture.loadFromFile("Assets/Sprites/Levels/Main Menu/howToPlay.png");	//Load the how to play texture for mouse input
	helpSprite.setTexture(&helpTexture);
	helpSprite.setPosition(330, 550);
	helpSprite.setSize(sf::Vector2f(348, 28));
	helpSprite.setCollisionBox(sf::FloatRect(0, 0, 348, 28));	//Set the collision box for mouse input

	backgroundTexture.loadFromFile("Assets/Sprites/Levels/Main Menu/background.png");	//Load the background texture and set the size to the window
	backgroundSprite.setTexture(&backgroundTexture);
	backgroundSprite.setSize(sf::Vector2f(1024, 768));
}


MainMenu::~MainMenu()
{
}

void MainMenu::update(float dt)
{
	mouseCursor.update(userInput->getMouseX(), userInput->getMouseY());	//Update the mouseCursor object's position

	if (userInput->isMouseLeftDown() == true)	//If we left click
	{
		if (Collision::checkBoundingBox(&mouseCursor, &startSprite))	//If the mouse collides with start game
		{
			currentLevel = Level::QueryLevel(LevelType_Lives);	//Set the level to the lives screen then eventually to the main game
		} 

		else if (Collision::checkBoundingBox(&mouseCursor, &helpSprite))	//If the mouse collides with the how to play sprite
		{
			currentLevel = Level::QueryLevel(LevelType_HowToPlay);	//Set the level to the how to play screen
		}
	}
}

void MainMenu::handleInput(float dt)
{

}

void MainMenu::render()
{
	window->draw(backgroundSprite);
	window->draw(startSprite);
	window->draw(helpSprite);
}